%------------------------------------------------------------------------------
% File     : DAT160^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Hamming stream 260
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [Loc10] Lochbihler (2010), Coinductive
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : hamming_stream__260.p [Bla16]

% Status   : Theorem
% Rating   : 0.00 v8.1.0, 0.25 v7.5.0, 0.00 v7.2.0, 0.25 v7.1.0
% Syntax   : Number of formulae    :  363 ( 112 unt;  60 typ;   0 def)
%            Number of atoms       :  700 ( 251 equ;   0 cnn)
%            Maximal formula atoms :   13 (   2 avg)
%            Number of connectives : 3197 (  41   ~;   3   |;  13   &;2849   @)
%                                         (   0 <=>; 291  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   17 (   6 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :  116 ( 116   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   57 (  56 usr;   4 con; 0-4 aty)
%            Number of variables   :  758 (  37   ^; 671   !;   5   ?; 758   :)
%                                         (  45  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:42:48.427
%------------------------------------------------------------------------------
%----Could-be-implicit typings (6)
thf(ty_t_Coinductive__List_Ollist,type,
    coinductive_llist: $tType > $tType ).

thf(ty_t_Product__Type_Ounit,type,
    product_unit: $tType ).

thf(ty_t_Extended__Nat_Oenat,type,
    extended_enat: $tType ).

thf(ty_t_Num_Onum,type,
    num: $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

%----Explicit typings (54)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Num_Onumeral,type,
    numeral: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ouminus,type,
    uminus: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Nat_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Num_Oneg__numeral,type,
    neg_numeral: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ocomm__ring__1,type,
    comm_ring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Num_Osemiring__numeral,type,
    semiring_numeral: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Osemigroup__mult,type,
    semigroup_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Oboolean__algebra,type,
    boolean_algebra: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Osemilattice__inf,type,
    semilattice_inf: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Coinductive__List_Olfinite,type,
    coinductive_lfinite: 
      !>[A: $tType] : ( ( coinductive_llist @ A ) > $o ) ).

thf(sy_c_Coinductive__List_Ollength,type,
    coinductive_llength: 
      !>[A: $tType] : ( ( coinductive_llist @ A ) > extended_enat ) ).

thf(sy_c_Coinductive__List_Ollist_OLCons,type,
    coinductive_LCons: 
      !>[A: $tType] : ( A > ( coinductive_llist @ A ) > ( coinductive_llist @ A ) ) ).

thf(sy_c_Coinductive__List_Ollist_Olmap,type,
    coinductive_lmap: 
      !>[A: $tType,Aa: $tType] : ( ( A > Aa ) > ( coinductive_llist @ A ) > ( coinductive_llist @ Aa ) ) ).

thf(sy_c_Coinductive__List_Ollist_Oltl,type,
    coinductive_ltl: 
      !>[A: $tType] : ( ( coinductive_llist @ A ) > ( coinductive_llist @ A ) ) ).

thf(sy_c_Extended__Nat_Oenat,type,
    extended_enat2: nat > extended_enat ).

thf(sy_c_Extended__Nat_Oenat_Orec__enat,type,
    extended_rec_enat: 
      !>[T: $tType] : ( ( nat > T ) > T > extended_enat > T ) ).

thf(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

thf(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Ouminus__class_Ouminus,type,
    uminus_uminus: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Hamming__Stream__Mirabelle__rwekfkwckg_Ohamming,type,
    hammin2015774020amming: coinductive_llist @ nat ).

thf(sy_c_Hamming__Stream__Mirabelle__rwekfkwckg_Ohamming_H,type,
    hammin1630468845amming: product_unit > ( coinductive_llist @ nat ) ).

thf(sy_c_Hamming__Stream__Mirabelle__rwekfkwckg_Oord__class_Olmerge,type,
    hammin1138290136lmerge: 
      !>[A: $tType] : ( ( coinductive_llist @ A ) > ( coinductive_llist @ A ) > ( coinductive_llist @ A ) ) ).

thf(sy_c_Hamming__Stream__Mirabelle__rwekfkwckg_Osmooth,type,
    hammin1195055315smooth: nat > $o ).

thf(sy_c_Lattices_Oinf__class_Oinf,type,
    inf_inf: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Num_OBitM,type,
    bitM: num > num ).

thf(sy_c_Num_Oneg__numeral__class_Odbl,type,
    neg_numeral_dbl: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Num_Oneg__numeral__class_Odbl__dec,type,
    neg_numeral_dbl_dec: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Num_Oneg__numeral__class_Odbl__inc,type,
    neg_numeral_dbl_inc: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Num_Oneg__numeral__class_Osub,type,
    neg_numeral_sub: 
      !>[A: $tType] : ( num > num > A ) ).

thf(sy_c_Num_Onum_OBit0,type,
    bit0: num > num ).

thf(sy_c_Num_Onum_OBit1,type,
    bit1: num > num ).

thf(sy_c_Num_Onum_OOne,type,
    one2: num ).

thf(sy_c_Num_Onumeral__class_Onumeral,type,
    numeral_numeral: 
      !>[A: $tType] : ( num > A ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Product__Type_OUnity,type,
    product_Unity: product_unit ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_v_n____,type,
    n: nat ).

%----Relevant facts (252)
thf(fact_0__092_060open_062lfinite_Ahamming_092_060close_062,axiom,
    coinductive_lfinite @ nat @ hammin2015774020amming ).

% \<open>lfinite hamming\<close>
thf(fact_1_llength__lmerge__above,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [Xs: coinductive_llist @ A,Ys: coinductive_llist @ A] : ( ord_less_eq @ extended_enat @ ( inf_inf @ extended_enat @ ( coinductive_llength @ A @ Xs ) @ ( coinductive_llength @ A @ Ys ) ) @ ( coinductive_llength @ A @ ( hammin1138290136lmerge @ A @ Xs @ Ys ) ) ) ) ).

% llength_lmerge_above
thf(fact_2_n,axiom,
    ( ( coinductive_llength @ nat @ hammin2015774020amming )
    = ( extended_enat2 @ n ) ) ).

% n
thf(fact_3_llength__lmap,axiom,
    ! [A: $tType,B: $tType,F: B > A,Xs: coinductive_llist @ B] :
      ( ( coinductive_llength @ A @ ( coinductive_lmap @ B @ A @ F @ Xs ) )
      = ( coinductive_llength @ B @ Xs ) ) ).

% llength_lmap
thf(fact_4_le__inf__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X @ ( inf_inf @ A @ Y @ Z ) )
          = ( ( ord_less_eq @ A @ X @ Y )
            & ( ord_less_eq @ A @ X @ Z ) ) ) ) ).

% le_inf_iff
thf(fact_5_inf_Obounded__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ ( inf_inf @ A @ B2 @ C ) )
          = ( ( ord_less_eq @ A @ A2 @ B2 )
            & ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% inf.bounded_iff
thf(fact_6_semiring__norm_I169_J,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type2 @ A ) )
     => ! [V: num,W: num,Z: A] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ V ) @ ( times_times @ A @ ( numeral_numeral @ A @ W ) @ Z ) )
          = ( times_times @ A @ ( numeral_numeral @ A @ ( times_times @ num @ V @ W ) ) @ Z ) ) ) ).

% semiring_norm(169)
thf(fact_7_numeral__times__numeral,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ M ) @ ( numeral_numeral @ A @ N ) )
          = ( numeral_numeral @ A @ ( times_times @ num @ M @ N ) ) ) ) ).

% numeral_times_numeral
thf(fact_8_numeral__le__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( ord_less_eq @ A @ ( numeral_numeral @ A @ M ) @ ( numeral_numeral @ A @ N ) )
          = ( ord_less_eq @ num @ M @ N ) ) ) ).

% numeral_le_iff
thf(fact_9_semiring__norm_I85_J,axiom,
    ! [M: num] :
      ( ( bit0 @ M )
     != one2 ) ).

% semiring_norm(85)
thf(fact_10_semiring__norm_I83_J,axiom,
    ! [N: num] :
      ( one2
     != ( bit0 @ N ) ) ).

% semiring_norm(83)
thf(fact_11_semiring__norm_I86_J,axiom,
    ! [M: num] :
      ( ( bit1 @ M )
     != one2 ) ).

% semiring_norm(86)
thf(fact_12_semiring__norm_I84_J,axiom,
    ! [N: num] :
      ( one2
     != ( bit1 @ N ) ) ).

% semiring_norm(84)
thf(fact_13_semiring__norm_I89_J,axiom,
    ! [M: num,N: num] :
      ( ( bit1 @ M )
     != ( bit0 @ N ) ) ).

% semiring_norm(89)
thf(fact_14_semiring__norm_I90_J,axiom,
    ! [M: num,N: num] :
      ( ( ( bit1 @ M )
        = ( bit1 @ N ) )
      = ( M = N ) ) ).

% semiring_norm(90)
thf(fact_15_num_Oinject_I2_J,axiom,
    ! [X3: num,Y3: num] :
      ( ( ( bit1 @ X3 )
        = ( bit1 @ Y3 ) )
      = ( X3 = Y3 ) ) ).

% num.inject(2)
thf(fact_16_semiring__norm_I87_J,axiom,
    ! [M: num,N: num] :
      ( ( ( bit0 @ M )
        = ( bit0 @ N ) )
      = ( M = N ) ) ).

% semiring_norm(87)
thf(fact_17_num_Oinject_I1_J,axiom,
    ! [X2: num,Y2: num] :
      ( ( ( bit0 @ X2 )
        = ( bit0 @ Y2 ) )
      = ( X2 = Y2 ) ) ).

% num.inject(1)
thf(fact_18__092_060open_062_092_060And_062thesis_O_A_I_092_060And_062n_O_Allength_Ahamming_A_061_Aenat_An_A_092_060Longrightarrow_062_Athesis_J_A_092_060Longrightarrow_062_Athesis_092_060close_062,axiom,
    ~ ! [N2: nat] :
        ( ( coinductive_llength @ nat @ hammin2015774020amming )
       != ( extended_enat2 @ N2 ) ) ).

% \<open>\<And>thesis. (\<And>n. llength hamming = enat n \<Longrightarrow> thesis) \<Longrightarrow> thesis\<close>
thf(fact_19_numeral__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( ( numeral_numeral @ A @ M )
            = ( numeral_numeral @ A @ N ) )
          = ( M = N ) ) ) ).

% numeral_eq_iff
thf(fact_20_inf__right__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ X @ Y ) @ Y )
          = ( inf_inf @ A @ X @ Y ) ) ) ).

% inf_right_idem
thf(fact_21_inf_Oright__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ A2 @ B2 ) @ B2 )
          = ( inf_inf @ A @ A2 @ B2 ) ) ) ).

% inf.right_idem
thf(fact_22_inf__left__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( inf_inf @ A @ X @ ( inf_inf @ A @ X @ Y ) )
          = ( inf_inf @ A @ X @ Y ) ) ) ).

% inf_left_idem
thf(fact_23_inf_Oleft__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( inf_inf @ A @ A2 @ ( inf_inf @ A @ A2 @ B2 ) )
          = ( inf_inf @ A @ A2 @ B2 ) ) ) ).

% inf.left_idem
thf(fact_24_inf__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( inf_inf @ A @ X @ X )
          = X ) ) ).

% inf_idem
thf(fact_25_inf_Oidem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( inf_inf @ A @ A2 @ A2 )
          = A2 ) ) ).

% inf.idem
thf(fact_26_inf__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( semilattice_inf @ B @ ( type2 @ B ) )
     => ( ( inf_inf @ ( A > B ) )
        = ( ^ [F2: A > B,G: A > B,X4: A] : ( inf_inf @ B @ ( F2 @ X4 ) @ ( G @ X4 ) ) ) ) ) ).

% inf_apply
thf(fact_27_semiring__norm_I88_J,axiom,
    ! [M: num,N: num] :
      ( ( bit0 @ M )
     != ( bit1 @ N ) ) ).

% semiring_norm(88)
thf(fact_28_semiring__norm_I13_J,axiom,
    ! [M: num,N: num] :
      ( ( times_times @ num @ ( bit0 @ M ) @ ( bit0 @ N ) )
      = ( bit0 @ ( bit0 @ ( times_times @ num @ M @ N ) ) ) ) ).

% semiring_norm(13)
thf(fact_29_lfinite__lmap,axiom,
    ! [A: $tType,B: $tType,F: B > A,Xs: coinductive_llist @ B] :
      ( ( coinductive_lfinite @ A @ ( coinductive_lmap @ B @ A @ F @ Xs ) )
      = ( coinductive_lfinite @ B @ Xs ) ) ).

% lfinite_lmap
thf(fact_30_semiring__norm_I11_J,axiom,
    ! [M: num] :
      ( ( times_times @ num @ M @ one2 )
      = M ) ).

% semiring_norm(11)
thf(fact_31_semiring__norm_I12_J,axiom,
    ! [N: num] :
      ( ( times_times @ num @ one2 @ N )
      = N ) ).

% semiring_norm(12)
thf(fact_32_semiring__norm_I73_J,axiom,
    ! [M: num,N: num] :
      ( ( ord_less_eq @ num @ ( bit1 @ M ) @ ( bit1 @ N ) )
      = ( ord_less_eq @ num @ M @ N ) ) ).

% semiring_norm(73)
thf(fact_33_semiring__norm_I71_J,axiom,
    ! [M: num,N: num] :
      ( ( ord_less_eq @ num @ ( bit0 @ M ) @ ( bit0 @ N ) )
      = ( ord_less_eq @ num @ M @ N ) ) ).

% semiring_norm(71)
thf(fact_34_semiring__norm_I68_J,axiom,
    ! [N: num] : ( ord_less_eq @ num @ one2 @ N ) ).

% semiring_norm(68)
thf(fact_35_semiring__norm_I14_J,axiom,
    ! [M: num,N: num] :
      ( ( times_times @ num @ ( bit0 @ M ) @ ( bit1 @ N ) )
      = ( bit0 @ ( times_times @ num @ M @ ( bit1 @ N ) ) ) ) ).

% semiring_norm(14)
thf(fact_36_semiring__norm_I15_J,axiom,
    ! [M: num,N: num] :
      ( ( times_times @ num @ ( bit1 @ M ) @ ( bit0 @ N ) )
      = ( bit0 @ ( times_times @ num @ ( bit1 @ M ) @ N ) ) ) ).

% semiring_norm(15)
thf(fact_37_semiring__norm_I72_J,axiom,
    ! [M: num,N: num] :
      ( ( ord_less_eq @ num @ ( bit0 @ M ) @ ( bit1 @ N ) )
      = ( ord_less_eq @ num @ M @ N ) ) ).

% semiring_norm(72)
thf(fact_38_semiring__norm_I70_J,axiom,
    ! [M: num] :
      ~ ( ord_less_eq @ num @ ( bit1 @ M ) @ one2 ) ).

% semiring_norm(70)
thf(fact_39_semiring__norm_I69_J,axiom,
    ! [M: num] :
      ~ ( ord_less_eq @ num @ ( bit0 @ M ) @ one2 ) ).

% semiring_norm(69)
thf(fact_40_lfinite__llength__enat,axiom,
    ! [A: $tType,Xs: coinductive_llist @ A] :
      ( ( coinductive_lfinite @ A @ Xs )
     => ? [N2: nat] :
          ( ( coinductive_llength @ A @ Xs )
          = ( extended_enat2 @ N2 ) ) ) ).

% lfinite_llength_enat
thf(fact_41_llength__eq__enat__lfiniteD,axiom,
    ! [A: $tType,Xs: coinductive_llist @ A,N: nat] :
      ( ( ( coinductive_llength @ A @ Xs )
        = ( extended_enat2 @ N ) )
     => ( coinductive_lfinite @ A @ Xs ) ) ).

% llength_eq_enat_lfiniteD
thf(fact_42_lfinite__conv__llength__enat,axiom,
    ! [A: $tType] :
      ( ( coinductive_lfinite @ A )
      = ( ^ [Xs2: coinductive_llist @ A] :
          ? [N3: nat] :
            ( ( coinductive_llength @ A @ Xs2 )
            = ( extended_enat2 @ N3 ) ) ) ) ).

% lfinite_conv_llength_enat
thf(fact_43_le__num__One__iff,axiom,
    ! [X: num] :
      ( ( ord_less_eq @ num @ X @ one2 )
      = ( X = one2 ) ) ).

% le_num_One_iff
thf(fact_44_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G2: A > B] :
      ( ! [X5: A] :
          ( ( F @ X5 )
          = ( G2 @ X5 ) )
     => ( F = G2 ) ) ).

% ext
thf(fact_45_linfinite__lmerge,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [Xs: coinductive_llist @ A,Ys: coinductive_llist @ A] :
          ( ~ ( coinductive_lfinite @ A @ Xs )
         => ( ~ ( coinductive_lfinite @ A @ Ys )
           => ~ ( coinductive_lfinite @ A @ ( hammin1138290136lmerge @ A @ Xs @ Ys ) ) ) ) ) ).

% linfinite_lmerge
thf(fact_46_lfinite__lmergeI,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [Xs: coinductive_llist @ A,Ys: coinductive_llist @ A] :
          ( ( coinductive_lfinite @ A @ Xs )
         => ( ( coinductive_lfinite @ A @ Ys )
           => ( coinductive_lfinite @ A @ ( hammin1138290136lmerge @ A @ Xs @ Ys ) ) ) ) ) ).

% lfinite_lmergeI
thf(fact_47_lfinite__lmergeD,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [Xs: coinductive_llist @ A,Ys: coinductive_llist @ A] :
          ( ( coinductive_lfinite @ A @ ( hammin1138290136lmerge @ A @ Xs @ Ys ) )
         => ( ( coinductive_lfinite @ A @ Xs )
            | ( coinductive_lfinite @ A @ Ys ) ) ) ) ).

% lfinite_lmergeD
thf(fact_48_wlog__linorder__le,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > A > $o,B2: A,A2: A] :
          ( ! [A3: A,B3: A] :
              ( ( ord_less_eq @ A @ A3 @ B3 )
             => ( P @ A3 @ B3 ) )
         => ( ( ( P @ B2 @ A2 )
             => ( P @ A2 @ B2 ) )
           => ( P @ A2 @ B2 ) ) ) ) ).

% wlog_linorder_le
thf(fact_49_inf__left__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ X @ ( inf_inf @ A @ Y @ Z ) )
          = ( inf_inf @ A @ Y @ ( inf_inf @ A @ X @ Z ) ) ) ) ).

% inf_left_commute
thf(fact_50_inf_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A,C: A] :
          ( ( inf_inf @ A @ B2 @ ( inf_inf @ A @ A2 @ C ) )
          = ( inf_inf @ A @ A2 @ ( inf_inf @ A @ B2 @ C ) ) ) ) ).

% inf.left_commute
thf(fact_51_inf__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( inf_inf @ A )
        = ( ^ [X4: A,Y4: A] : ( inf_inf @ A @ Y4 @ X4 ) ) ) ) ).

% inf_commute
thf(fact_52_inf_Ocommute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( inf_inf @ A )
        = ( ^ [A4: A,B4: A] : ( inf_inf @ A @ B4 @ A4 ) ) ) ) ).

% inf.commute
thf(fact_53_inf__assoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ X @ Y ) @ Z )
          = ( inf_inf @ A @ X @ ( inf_inf @ A @ Y @ Z ) ) ) ) ).

% inf_assoc
thf(fact_54_inf_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ A2 @ B2 ) @ C )
          = ( inf_inf @ A @ A2 @ ( inf_inf @ A @ B2 @ C ) ) ) ) ).

% inf.assoc
thf(fact_55_inf__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( semilattice_inf @ B @ ( type2 @ B ) )
     => ( ( inf_inf @ ( A > B ) )
        = ( ^ [F2: A > B,G: A > B,X4: A] : ( inf_inf @ B @ ( F2 @ X4 ) @ ( G @ X4 ) ) ) ) ) ).

% inf_fun_def
thf(fact_56_inf__sup__aci_I1_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ( ( inf_inf @ A )
        = ( ^ [X4: A,Y4: A] : ( inf_inf @ A @ Y4 @ X4 ) ) ) ) ).

% inf_sup_aci(1)
thf(fact_57_inf__sup__aci_I2_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ X @ Y ) @ Z )
          = ( inf_inf @ A @ X @ ( inf_inf @ A @ Y @ Z ) ) ) ) ).

% inf_sup_aci(2)
thf(fact_58_inf__sup__aci_I3_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ X @ ( inf_inf @ A @ Y @ Z ) )
          = ( inf_inf @ A @ Y @ ( inf_inf @ A @ X @ Z ) ) ) ) ).

% inf_sup_aci(3)
thf(fact_59_inf__sup__aci_I4_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( inf_inf @ A @ X @ ( inf_inf @ A @ X @ Y ) )
          = ( inf_inf @ A @ X @ Y ) ) ) ).

% inf_sup_aci(4)
thf(fact_60_num_Odistinct_I5_J,axiom,
    ! [X2: num,X3: num] :
      ( ( bit0 @ X2 )
     != ( bit1 @ X3 ) ) ).

% num.distinct(5)
thf(fact_61_num_Odistinct_I3_J,axiom,
    ! [X3: num] :
      ( one2
     != ( bit1 @ X3 ) ) ).

% num.distinct(3)
thf(fact_62_num_Odistinct_I1_J,axiom,
    ! [X2: num] :
      ( one2
     != ( bit0 @ X2 ) ) ).

% num.distinct(1)
thf(fact_63_inf_OcoboundedI2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [B2: A,C: A,A2: A] :
          ( ( ord_less_eq @ A @ B2 @ C )
         => ( ord_less_eq @ A @ ( inf_inf @ A @ A2 @ B2 ) @ C ) ) ) ).

% inf.coboundedI2
thf(fact_64_inf_OcoboundedI1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ C )
         => ( ord_less_eq @ A @ ( inf_inf @ A @ A2 @ B2 ) @ C ) ) ) ).

% inf.coboundedI1
thf(fact_65_inf_Oabsorb__iff2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [B4: A,A4: A] :
              ( ( inf_inf @ A @ A4 @ B4 )
              = B4 ) ) ) ) ).

% inf.absorb_iff2
thf(fact_66_inf_Oabsorb__iff1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [A4: A,B4: A] :
              ( ( inf_inf @ A @ A4 @ B4 )
              = A4 ) ) ) ) ).

% inf.absorb_iff1
thf(fact_67_inf_Ocobounded2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ A2 @ B2 ) @ B2 ) ) ).

% inf.cobounded2
thf(fact_68_inf_Ocobounded1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ A2 @ B2 ) @ A2 ) ) ).

% inf.cobounded1
thf(fact_69_inf_Oorder__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [A4: A,B4: A] :
              ( A4
              = ( inf_inf @ A @ A4 @ B4 ) ) ) ) ) ).

% inf.order_iff
thf(fact_70_inf__greatest,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ X @ Z )
           => ( ord_less_eq @ A @ X @ ( inf_inf @ A @ Y @ Z ) ) ) ) ) ).

% inf_greatest
thf(fact_71_inf_OboundedI,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ A2 @ C )
           => ( ord_less_eq @ A @ A2 @ ( inf_inf @ A @ B2 @ C ) ) ) ) ) ).

% inf.boundedI
thf(fact_72_inf_OboundedE,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ ( inf_inf @ A @ B2 @ C ) )
         => ~ ( ( ord_less_eq @ A @ A2 @ B2 )
             => ~ ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% inf.boundedE
thf(fact_73_inf__absorb2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ( ord_less_eq @ A @ Y @ X )
         => ( ( inf_inf @ A @ X @ Y )
            = Y ) ) ) ).

% inf_absorb2
thf(fact_74_inf__absorb1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( inf_inf @ A @ X @ Y )
            = X ) ) ) ).

% inf_absorb1
thf(fact_75_inf_Oabsorb2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A] :
          ( ( ord_less_eq @ A @ B2 @ A2 )
         => ( ( inf_inf @ A @ A2 @ B2 )
            = B2 ) ) ) ).

% inf.absorb2
thf(fact_76_inf_Oabsorb1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( inf_inf @ A @ A2 @ B2 )
            = A2 ) ) ) ).

% inf.absorb1
thf(fact_77_le__iff__inf,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [X4: A,Y4: A] :
              ( ( inf_inf @ A @ X4 @ Y4 )
              = X4 ) ) ) ) ).

% le_iff_inf
thf(fact_78_inf__unique,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [F: A > A > A,X: A,Y: A] :
          ( ! [X5: A,Y5: A] : ( ord_less_eq @ A @ ( F @ X5 @ Y5 ) @ X5 )
         => ( ! [X5: A,Y5: A] : ( ord_less_eq @ A @ ( F @ X5 @ Y5 ) @ Y5 )
           => ( ! [X5: A,Y5: A,Z2: A] :
                  ( ( ord_less_eq @ A @ X5 @ Y5 )
                 => ( ( ord_less_eq @ A @ X5 @ Z2 )
                   => ( ord_less_eq @ A @ X5 @ ( F @ Y5 @ Z2 ) ) ) )
             => ( ( inf_inf @ A @ X @ Y )
                = ( F @ X @ Y ) ) ) ) ) ) ).

% inf_unique
thf(fact_79_inf_OorderI,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( A2
            = ( inf_inf @ A @ A2 @ B2 ) )
         => ( ord_less_eq @ A @ A2 @ B2 ) ) ) ).

% inf.orderI
thf(fact_80_inf_OorderE,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( A2
            = ( inf_inf @ A @ A2 @ B2 ) ) ) ) ).

% inf.orderE
thf(fact_81_le__infI2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [B2: A,X: A,A2: A] :
          ( ( ord_less_eq @ A @ B2 @ X )
         => ( ord_less_eq @ A @ ( inf_inf @ A @ A2 @ B2 ) @ X ) ) ) ).

% le_infI2
thf(fact_82_le__infI1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A2: A,X: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ X )
         => ( ord_less_eq @ A @ ( inf_inf @ A @ A2 @ B2 ) @ X ) ) ) ).

% le_infI1
thf(fact_83_inf__mono,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,B2: A,D: A] :
          ( ( ord_less_eq @ A @ A2 @ C )
         => ( ( ord_less_eq @ A @ B2 @ D )
           => ( ord_less_eq @ A @ ( inf_inf @ A @ A2 @ B2 ) @ ( inf_inf @ A @ C @ D ) ) ) ) ) ).

% inf_mono
thf(fact_84_le__infI,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,A2: A,B2: A] :
          ( ( ord_less_eq @ A @ X @ A2 )
         => ( ( ord_less_eq @ A @ X @ B2 )
           => ( ord_less_eq @ A @ X @ ( inf_inf @ A @ A2 @ B2 ) ) ) ) ) ).

% le_infI
thf(fact_85_le__infE,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,A2: A,B2: A] :
          ( ( ord_less_eq @ A @ X @ ( inf_inf @ A @ A2 @ B2 ) )
         => ~ ( ( ord_less_eq @ A @ X @ A2 )
             => ~ ( ord_less_eq @ A @ X @ B2 ) ) ) ) ).

% le_infE
thf(fact_86_inf__le2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ X @ Y ) @ Y ) ) ).

% inf_le2
thf(fact_87_inf__le1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ X @ Y ) @ X ) ) ).

% inf_le1
thf(fact_88_inf__sup__ord_I1_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ X @ Y ) @ X ) ) ).

% inf_sup_ord(1)
thf(fact_89_inf__sup__ord_I2_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ X @ Y ) @ Y ) ) ).

% inf_sup_ord(2)
thf(fact_90_num_Oexhaust,axiom,
    ! [Y: num] :
      ( ( Y != one2 )
     => ( ! [X22: num] :
            ( Y
           != ( bit0 @ X22 ) )
       => ~ ! [X32: num] :
              ( Y
             != ( bit1 @ X32 ) ) ) ) ).

% num.exhaust
thf(fact_91_num_Oinduct,axiom,
    ! [P: num > $o,Num: num] :
      ( ( P @ one2 )
     => ( ! [X5: num] :
            ( ( P @ X5 )
           => ( P @ ( bit0 @ X5 ) ) )
       => ( ! [X5: num] :
              ( ( P @ X5 )
             => ( P @ ( bit1 @ X5 ) ) )
         => ( P @ Num ) ) ) ) ).

% num.induct
thf(fact_92_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( numeral_numeral @ A @ one2 ) )
          = A2 ) ) ).

% mult_numeral_1_right
thf(fact_93_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ one2 ) @ A2 )
          = A2 ) ) ).

% mult_numeral_1
thf(fact_94_numeral__le__enat__iff,axiom,
    ! [M: num,N: nat] :
      ( ( ord_less_eq @ extended_enat @ ( numeral_numeral @ extended_enat @ M ) @ ( extended_enat2 @ N ) )
      = ( ord_less_eq @ nat @ ( numeral_numeral @ nat @ M ) @ N ) ) ).

% numeral_le_enat_iff
thf(fact_95_enat__ord__simps_I1_J,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ extended_enat @ ( extended_enat2 @ M ) @ ( extended_enat2 @ N ) )
      = ( ord_less_eq @ nat @ M @ N ) ) ).

% enat_ord_simps(1)
thf(fact_96_times__enat__simps_I1_J,axiom,
    ! [M: nat,N: nat] :
      ( ( times_times @ extended_enat @ ( extended_enat2 @ M ) @ ( extended_enat2 @ N ) )
      = ( extended_enat2 @ ( times_times @ nat @ M @ N ) ) ) ).

% times_enat_simps(1)
thf(fact_97_enat__ord__number_I1_J,axiom,
    ! [M: num,N: num] :
      ( ( ord_less_eq @ extended_enat @ ( numeral_numeral @ extended_enat @ M ) @ ( numeral_numeral @ extended_enat @ N ) )
      = ( ord_less_eq @ nat @ ( numeral_numeral @ nat @ M ) @ ( numeral_numeral @ nat @ N ) ) ) ).

% enat_ord_number(1)
thf(fact_98_ltl__hamming,axiom,
    ( ( coinductive_ltl @ nat @ hammin2015774020amming )
    = ( hammin1138290136lmerge @ nat @ ( coinductive_lmap @ nat @ nat @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit0 @ one2 ) ) ) @ hammin2015774020amming ) @ ( hammin1138290136lmerge @ nat @ ( coinductive_lmap @ nat @ nat @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit1 @ one2 ) ) ) @ hammin2015774020amming ) @ ( coinductive_lmap @ nat @ nat @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit1 @ ( bit0 @ one2 ) ) ) ) @ hammin2015774020amming ) ) ) ) ).

% ltl_hamming
thf(fact_99_enat_Oinject,axiom,
    ! [Nat: nat,Nat2: nat] :
      ( ( ( extended_enat2 @ Nat )
        = ( extended_enat2 @ Nat2 ) )
      = ( Nat = Nat2 ) ) ).

% enat.inject
thf(fact_100_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A] : ( ord_less_eq @ A @ X @ X ) ) ).

% order_refl
thf(fact_101_enat__ile,axiom,
    ! [N: extended_enat,M: nat] :
      ( ( ord_less_eq @ extended_enat @ N @ ( extended_enat2 @ M ) )
     => ? [K: nat] :
          ( N
          = ( extended_enat2 @ K ) ) ) ).

% enat_ile
thf(fact_102_numeral__eq__enat,axiom,
    ( ( numeral_numeral @ extended_enat )
    = ( ^ [K2: num] : ( extended_enat2 @ ( numeral_numeral @ nat @ K2 ) ) ) ) ).

% numeral_eq_enat
thf(fact_103_smooth5,axiom,
    hammin1195055315smooth @ ( numeral_numeral @ nat @ ( bit1 @ ( bit0 @ one2 ) ) ) ).

% smooth5
thf(fact_104_dbl__inc__simps_I5_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K3: num] :
          ( ( neg_numeral_dbl_inc @ A @ ( numeral_numeral @ A @ K3 ) )
          = ( numeral_numeral @ A @ ( bit1 @ K3 ) ) ) ) ).

% dbl_inc_simps(5)
thf(fact_105_lfinite__ltl,axiom,
    ! [A: $tType,Xs: coinductive_llist @ A] :
      ( ( coinductive_lfinite @ A @ ( coinductive_ltl @ A @ Xs ) )
      = ( coinductive_lfinite @ A @ Xs ) ) ).

% lfinite_ltl
thf(fact_106_ltl__lmap,axiom,
    ! [A: $tType,B: $tType,F: B > A,Xs: coinductive_llist @ B] :
      ( ( coinductive_ltl @ A @ ( coinductive_lmap @ B @ A @ F @ Xs ) )
      = ( coinductive_lmap @ B @ A @ F @ ( coinductive_ltl @ B @ Xs ) ) ) ).

% ltl_lmap
thf(fact_107_smooth__times,axiom,
    ! [X: nat,Y: nat] :
      ( ( hammin1195055315smooth @ ( times_times @ nat @ X @ Y ) )
      = ( ( hammin1195055315smooth @ X )
        & ( hammin1195055315smooth @ Y ) ) ) ).

% smooth_times
thf(fact_108_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G2: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G2 )
         => ( ord_less_eq @ B @ ( F @ X ) @ ( G2 @ X ) ) ) ) ).

% le_funD
thf(fact_109_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G2: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G2 )
         => ( ord_less_eq @ B @ ( F @ X ) @ ( G2 @ X ) ) ) ) ).

% le_funE
thf(fact_110_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G2: A > B] :
          ( ! [X5: A] : ( ord_less_eq @ B @ ( F @ X5 ) @ ( G2 @ X5 ) )
         => ( ord_less_eq @ ( A > B ) @ F @ G2 ) ) ) ).

% le_funI
thf(fact_111_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ( ( ord_less_eq @ ( A > B ) )
        = ( ^ [F2: A > B,G: A > B] :
            ! [X4: A] : ( ord_less_eq @ B @ ( F2 @ X4 ) @ ( G @ X4 ) ) ) ) ) ).

% le_fun_def
thf(fact_112_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B > A,B2: B,C: B] :
          ( ( ord_less_eq @ A @ A2 @ ( F @ B2 ) )
         => ( ( ord_less_eq @ B @ B2 @ C )
           => ( ! [X5: B,Y5: B] :
                  ( ( ord_less_eq @ B @ X5 @ Y5 )
                 => ( ord_less_eq @ A @ ( F @ X5 ) @ ( F @ Y5 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_subst1
thf(fact_113_order__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 @ ( type2 @ C2 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B2: A,F: A > C2,C: C2] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ C2 @ ( F @ B2 ) @ C )
           => ( ! [X5: A,Y5: A] :
                  ( ( ord_less_eq @ A @ X5 @ Y5 )
                 => ( ord_less_eq @ C2 @ ( F @ X5 ) @ ( F @ Y5 ) ) )
             => ( ord_less_eq @ C2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_subst2
thf(fact_114_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B > A,B2: B,C: B] :
          ( ( A2
            = ( F @ B2 ) )
         => ( ( ord_less_eq @ B @ B2 @ C )
           => ( ! [X5: B,Y5: B] :
                  ( ( ord_less_eq @ B @ X5 @ Y5 )
                 => ( ord_less_eq @ A @ ( F @ X5 ) @ ( F @ Y5 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_115_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B2: A,F: A > B,C: B] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ( F @ B2 )
              = C )
           => ( ! [X5: A,Y5: A] :
                  ( ( ord_less_eq @ A @ X5 @ Y5 )
                 => ( ord_less_eq @ B @ ( F @ X5 ) @ ( F @ Y5 ) ) )
             => ( ord_less_eq @ B @ ( F @ A2 ) @ C ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_116_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ^ [Y6: A,Z3: A] : ( Y6 = Z3 ) )
        = ( ^ [X4: A,Y4: A] :
              ( ( ord_less_eq @ A @ X4 @ Y4 )
              & ( ord_less_eq @ A @ Y4 @ X4 ) ) ) ) ) ).

% eq_iff
thf(fact_117_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ X )
           => ( X = Y ) ) ) ) ).

% antisym
thf(fact_118_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
          | ( ord_less_eq @ A @ Y @ X ) ) ) ).

% linear
thf(fact_119_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( X = Y )
         => ( ord_less_eq @ A @ X @ Y ) ) ) ).

% eq_refl
thf(fact_120_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ~ ( ord_less_eq @ A @ X @ Y )
         => ( ord_less_eq @ A @ Y @ X ) ) ) ).

% le_cases
thf(fact_121_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ B2 @ C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% order.trans
thf(fact_122_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ( ord_less_eq @ A @ X @ Y )
           => ~ ( ord_less_eq @ A @ Y @ Z ) )
         => ( ( ( ord_less_eq @ A @ Y @ X )
             => ~ ( ord_less_eq @ A @ X @ Z ) )
           => ( ( ( ord_less_eq @ A @ X @ Z )
               => ~ ( ord_less_eq @ A @ Z @ Y ) )
             => ( ( ( ord_less_eq @ A @ Z @ Y )
                 => ~ ( ord_less_eq @ A @ Y @ X ) )
               => ( ( ( ord_less_eq @ A @ Y @ Z )
                   => ~ ( ord_less_eq @ A @ Z @ X ) )
                 => ~ ( ( ord_less_eq @ A @ Z @ X )
                     => ~ ( ord_less_eq @ A @ X @ Y ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_123_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ( ord_less_eq @ A @ Y @ X )
         => ( ( ord_less_eq @ A @ X @ Y )
            = ( X = Y ) ) ) ) ).

% antisym_conv
thf(fact_124_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( A2 = B2 )
         => ( ( ord_less_eq @ A @ B2 @ C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% ord_eq_le_trans
thf(fact_125_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( B2 = C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% ord_le_eq_trans
thf(fact_126_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ B2 @ A2 )
           => ( A2 = B2 ) ) ) ) ).

% order_class.order.antisym
thf(fact_127_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z )
           => ( ord_less_eq @ A @ X @ Z ) ) ) ) ).

% order_trans
thf(fact_128_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A] : ( ord_less_eq @ A @ A2 @ A2 ) ) ).

% dual_order.refl
thf(fact_129_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > A > $o,A2: A,B2: A] :
          ( ! [A3: A,B3: A] :
              ( ( ord_less_eq @ A @ A3 @ B3 )
             => ( P @ A3 @ B3 ) )
         => ( ! [A3: A,B3: A] :
                ( ( P @ B3 @ A3 )
               => ( P @ A3 @ B3 ) )
           => ( P @ A2 @ B2 ) ) ) ) ).

% linorder_wlog
thf(fact_130_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A,C: A] :
          ( ( ord_less_eq @ A @ B2 @ A2 )
         => ( ( ord_less_eq @ A @ C @ B2 )
           => ( ord_less_eq @ A @ C @ A2 ) ) ) ) ).

% dual_order.trans
thf(fact_131_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A] :
          ( ( ord_less_eq @ A @ B2 @ A2 )
         => ( ( ord_less_eq @ A @ A2 @ B2 )
           => ( A2 = B2 ) ) ) ) ).

% dual_order.antisym
thf(fact_132_smooth3,axiom,
    hammin1195055315smooth @ ( numeral_numeral @ nat @ ( bit1 @ one2 ) ) ).

% smooth3
thf(fact_133_smooth2,axiom,
    hammin1195055315smooth @ ( numeral_numeral @ nat @ ( bit0 @ one2 ) ) ).

% smooth2
thf(fact_134_le__cube,axiom,
    ! [M: nat] : ( ord_less_eq @ nat @ M @ ( times_times @ nat @ M @ ( times_times @ nat @ M @ M ) ) ) ).

% le_cube
thf(fact_135_le__square,axiom,
    ! [M: nat] : ( ord_less_eq @ nat @ M @ ( times_times @ nat @ M @ M ) ) ).

% le_square
thf(fact_136_mult__le__mono,axiom,
    ! [I: nat,J: nat,K3: nat,L: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ K3 @ L )
       => ( ord_less_eq @ nat @ ( times_times @ nat @ I @ K3 ) @ ( times_times @ nat @ J @ L ) ) ) ) ).

% mult_le_mono
thf(fact_137_mult__le__mono1,axiom,
    ! [I: nat,J: nat,K3: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ ( times_times @ nat @ I @ K3 ) @ ( times_times @ nat @ J @ K3 ) ) ) ).

% mult_le_mono1
thf(fact_138_mult__le__mono2,axiom,
    ! [I: nat,J: nat,K3: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ ( times_times @ nat @ K3 @ I ) @ ( times_times @ nat @ K3 @ J ) ) ) ).

% mult_le_mono2
thf(fact_139_nat__le__linear,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
      | ( ord_less_eq @ nat @ N @ M ) ) ).

% nat_le_linear
thf(fact_140_le__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( ord_less_eq @ nat @ N @ M )
       => ( M = N ) ) ) ).

% le_antisym
thf(fact_141_eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( M = N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% eq_imp_le
thf(fact_142_le__trans,axiom,
    ! [I: nat,J: nat,K3: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ J @ K3 )
       => ( ord_less_eq @ nat @ I @ K3 ) ) ) ).

% le_trans
thf(fact_143_le__refl,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ N @ N ) ).

% le_refl
thf(fact_144_enat_Osimps_I6_J,axiom,
    ! [T: $tType,F1: nat > T,F22: T,Nat: nat] :
      ( ( extended_rec_enat @ T @ F1 @ F22 @ ( extended_enat2 @ Nat ) )
      = ( F1 @ Nat ) ) ).

% enat.simps(6)
thf(fact_145_sub__num__simps_I5_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K3: num] :
          ( ( neg_numeral_sub @ A @ ( bit1 @ K3 ) @ one2 )
          = ( numeral_numeral @ A @ ( bit0 @ K3 ) ) ) ) ).

% sub_num_simps(5)
thf(fact_146_dbl__inc__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_dbl_inc @ A @ ( one_one @ A ) )
        = ( numeral_numeral @ A @ ( bit1 @ one2 ) ) ) ) ).

% dbl_inc_simps(3)
thf(fact_147_dbl__simps_I5_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K3: num] :
          ( ( neg_numeral_dbl @ A @ ( numeral_numeral @ A @ K3 ) )
          = ( numeral_numeral @ A @ ( bit0 @ K3 ) ) ) ) ).

% dbl_simps(5)
thf(fact_148_nat__1__eq__mult__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ( one_one @ nat )
        = ( times_times @ nat @ M @ N ) )
      = ( ( M
          = ( one_one @ nat ) )
        & ( N
          = ( one_one @ nat ) ) ) ) ).

% nat_1_eq_mult_iff
thf(fact_149_nat__mult__eq__1__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ( times_times @ nat @ M @ N )
        = ( one_one @ nat ) )
      = ( ( M
          = ( one_one @ nat ) )
        & ( N
          = ( one_one @ nat ) ) ) ) ).

% nat_mult_eq_1_iff
thf(fact_150_numeral__eq__one__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( ( numeral_numeral @ A @ N )
            = ( one_one @ A ) )
          = ( N = one2 ) ) ) ).

% numeral_eq_one_iff
thf(fact_151_one__eq__numeral__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( ( one_one @ A )
            = ( numeral_numeral @ A @ N ) )
          = ( one2 = N ) ) ) ).

% one_eq_numeral_iff
thf(fact_152_sub__num__simps_I9_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K3: num,L: num] :
          ( ( neg_numeral_sub @ A @ ( bit1 @ K3 ) @ ( bit1 @ L ) )
          = ( neg_numeral_dbl @ A @ ( neg_numeral_sub @ A @ K3 @ L ) ) ) ) ).

% sub_num_simps(9)
thf(fact_153_sub__num__simps_I6_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K3: num,L: num] :
          ( ( neg_numeral_sub @ A @ ( bit0 @ K3 ) @ ( bit0 @ L ) )
          = ( neg_numeral_dbl @ A @ ( neg_numeral_sub @ A @ K3 @ L ) ) ) ) ).

% sub_num_simps(6)
thf(fact_154_sub__num__simps_I8_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K3: num,L: num] :
          ( ( neg_numeral_sub @ A @ ( bit1 @ K3 ) @ ( bit0 @ L ) )
          = ( neg_numeral_dbl_inc @ A @ ( neg_numeral_sub @ A @ K3 @ L ) ) ) ) ).

% sub_num_simps(8)
thf(fact_155_numeral__le__one__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( ord_less_eq @ A @ ( numeral_numeral @ A @ N ) @ ( one_one @ A ) )
          = ( ord_less_eq @ num @ N @ one2 ) ) ) ).

% numeral_le_one_iff
thf(fact_156_dbl__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_dbl @ A @ ( one_one @ A ) )
        = ( numeral_numeral @ A @ ( bit0 @ one2 ) ) ) ) ).

% dbl_simps(3)
thf(fact_157_nat__mult__1,axiom,
    ! [N: nat] :
      ( ( times_times @ nat @ ( one_one @ nat ) @ N )
      = N ) ).

% nat_mult_1
thf(fact_158_nat__mult__1__right,axiom,
    ! [N: nat] :
      ( ( times_times @ nat @ N @ ( one_one @ nat ) )
      = N ) ).

% nat_mult_1_right
thf(fact_159_le__numeral__extra_I4_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type2 @ A ) )
     => ( ord_less_eq @ A @ ( one_one @ A ) @ ( one_one @ A ) ) ) ).

% le_numeral_extra(4)
thf(fact_160_one__enat__def,axiom,
    ( ( one_one @ extended_enat )
    = ( extended_enat2 @ ( one_one @ nat ) ) ) ).

% one_enat_def
thf(fact_161_enat__1__iff_I1_J,axiom,
    ! [X: nat] :
      ( ( ( extended_enat2 @ X )
        = ( one_one @ extended_enat ) )
      = ( X
        = ( one_one @ nat ) ) ) ).

% enat_1_iff(1)
thf(fact_162_enat__1__iff_I2_J,axiom,
    ! [X: nat] :
      ( ( ( one_one @ extended_enat )
        = ( extended_enat2 @ X ) )
      = ( X
        = ( one_one @ nat ) ) ) ).

% enat_1_iff(2)
thf(fact_163_one__le__numeral,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type2 @ A ) )
     => ! [N: num] : ( ord_less_eq @ A @ ( one_one @ A ) @ ( numeral_numeral @ A @ N ) ) ) ).

% one_le_numeral
thf(fact_164_numeral__One,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type2 @ A ) )
     => ( ( numeral_numeral @ A @ one2 )
        = ( one_one @ A ) ) ) ).

% numeral_One
thf(fact_165_numerals_I1_J,axiom,
    ( ( numeral_numeral @ nat @ one2 )
    = ( one_one @ nat ) ) ).

% numerals(1)
thf(fact_166_mult_Oright__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_mult @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( one_one @ A ) )
          = A2 ) ) ).

% mult.right_neutral
thf(fact_167_mult_Oleft__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_mult @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( one_one @ A ) @ A2 )
          = A2 ) ) ).

% mult.left_neutral
thf(fact_168_sub__num__simps_I7_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K3: num,L: num] :
          ( ( neg_numeral_sub @ A @ ( bit0 @ K3 ) @ ( bit1 @ L ) )
          = ( neg_numeral_dbl_dec @ A @ ( neg_numeral_sub @ A @ K3 @ L ) ) ) ) ).

% sub_num_simps(7)
thf(fact_169_dbl__dec__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_dbl_dec @ A @ ( one_one @ A ) )
        = ( one_one @ A ) ) ) ).

% dbl_dec_simps(3)
thf(fact_170_mult_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A,C: A] :
          ( ( times_times @ A @ B2 @ ( times_times @ A @ A2 @ C ) )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B2 @ C ) ) ) ) ).

% mult.left_commute
thf(fact_171_mult_Ocommute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type2 @ A ) )
     => ( ( times_times @ A )
        = ( ^ [A4: A,B4: A] : ( times_times @ A @ B4 @ A4 ) ) ) ) ).

% mult.commute
thf(fact_172_mult_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semigroup_mult @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( times_times @ A @ ( times_times @ A @ A2 @ B2 ) @ C )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B2 @ C ) ) ) ) ).

% mult.assoc
thf(fact_173_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( times_times @ A @ ( times_times @ A @ A2 @ B2 ) @ C )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B2 @ C ) ) ) ) ).

% ab_semigroup_mult_class.mult_ac(1)
thf(fact_174_one__reorient,axiom,
    ! [A: $tType] :
      ( ( one @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( ( one_one @ A )
            = X )
          = ( X
            = ( one_one @ A ) ) ) ) ).

% one_reorient
thf(fact_175_comm__monoid__mult__class_Omult__1,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( one_one @ A ) @ A2 )
          = A2 ) ) ).

% comm_monoid_mult_class.mult_1
thf(fact_176_mult_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( one_one @ A ) )
          = A2 ) ) ).

% mult.comm_neutral
thf(fact_177_hamming__unfold,axiom,
    ( hammin2015774020amming
    = ( coinductive_LCons @ nat @ ( one_one @ nat ) @ ( hammin1138290136lmerge @ nat @ ( coinductive_lmap @ nat @ nat @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit0 @ one2 ) ) ) @ hammin2015774020amming ) @ ( hammin1138290136lmerge @ nat @ ( coinductive_lmap @ nat @ nat @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit1 @ one2 ) ) ) @ hammin2015774020amming ) @ ( coinductive_lmap @ nat @ nat @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit1 @ ( bit0 @ one2 ) ) ) ) @ hammin2015774020amming ) ) ) ) ) ).

% hamming_unfold
thf(fact_178_sub__num__simps_I4_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K3: num] :
          ( ( neg_numeral_sub @ A @ ( bit0 @ K3 ) @ one2 )
          = ( numeral_numeral @ A @ ( bitM @ K3 ) ) ) ) ).

% sub_num_simps(4)
thf(fact_179_semiring__normalization__rules_I12_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( one_one @ A ) )
          = A2 ) ) ).

% semiring_normalization_rules(12)
thf(fact_180_llist_Oinject,axiom,
    ! [A: $tType,X21: A,X222: coinductive_llist @ A,Y21: A,Y22: coinductive_llist @ A] :
      ( ( ( coinductive_LCons @ A @ X21 @ X222 )
        = ( coinductive_LCons @ A @ Y21 @ Y22 ) )
      = ( ( X21 = Y21 )
        & ( X222 = Y22 ) ) ) ).

% llist.inject
thf(fact_181_lfinite__code_I2_J,axiom,
    ! [B: $tType,X: B,Xs: coinductive_llist @ B] :
      ( ( coinductive_lfinite @ B @ ( coinductive_LCons @ B @ X @ Xs ) )
      = ( coinductive_lfinite @ B @ Xs ) ) ).

% lfinite_code(2)
thf(fact_182_lfinite__LCons,axiom,
    ! [A: $tType,X: A,Xs: coinductive_llist @ A] :
      ( ( coinductive_lfinite @ A @ ( coinductive_LCons @ A @ X @ Xs ) )
      = ( coinductive_lfinite @ A @ Xs ) ) ).

% lfinite_LCons
thf(fact_183_dbl__dec__simps_I5_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K3: num] :
          ( ( neg_numeral_dbl_dec @ A @ ( numeral_numeral @ A @ K3 ) )
          = ( numeral_numeral @ A @ ( bitM @ K3 ) ) ) ) ).

% dbl_dec_simps(5)
thf(fact_184_ltl__simps_I2_J,axiom,
    ! [A: $tType,X21: A,X222: coinductive_llist @ A] :
      ( ( coinductive_ltl @ A @ ( coinductive_LCons @ A @ X21 @ X222 ) )
      = X222 ) ).

% ltl_simps(2)
thf(fact_185_lmap__eq__LCons__conv,axiom,
    ! [A: $tType,B: $tType,F: B > A,Xs: coinductive_llist @ B,Y: A,Ys: coinductive_llist @ A] :
      ( ( ( coinductive_lmap @ B @ A @ F @ Xs )
        = ( coinductive_LCons @ A @ Y @ Ys ) )
      = ( ? [X4: B,Xs3: coinductive_llist @ B] :
            ( ( Xs
              = ( coinductive_LCons @ B @ X4 @ Xs3 ) )
            & ( Y
              = ( F @ X4 ) )
            & ( Ys
              = ( coinductive_lmap @ B @ A @ F @ Xs3 ) ) ) ) ) ).

% lmap_eq_LCons_conv
thf(fact_186_llist_Osimps_I13_J,axiom,
    ! [B: $tType,A: $tType,F: A > B,X21: A,X222: coinductive_llist @ A] :
      ( ( coinductive_lmap @ A @ B @ F @ ( coinductive_LCons @ A @ X21 @ X222 ) )
      = ( coinductive_LCons @ B @ ( F @ X21 ) @ ( coinductive_lmap @ A @ B @ F @ X222 ) ) ) ).

% llist.simps(13)
thf(fact_187_lfinite__LConsI,axiom,
    ! [A: $tType,Xs: coinductive_llist @ A,X: A] :
      ( ( coinductive_lfinite @ A @ Xs )
     => ( coinductive_lfinite @ A @ ( coinductive_LCons @ A @ X @ Xs ) ) ) ).

% lfinite_LConsI
thf(fact_188_semiring__norm_I26_J,axiom,
    ( ( bitM @ one2 )
    = one2 ) ).

% semiring_norm(26)
thf(fact_189_semiring__norm_I28_J,axiom,
    ! [N: num] :
      ( ( bitM @ ( bit1 @ N ) )
      = ( bit1 @ ( bit0 @ N ) ) ) ).

% semiring_norm(28)
thf(fact_190_semiring__norm_I27_J,axiom,
    ! [N: num] :
      ( ( bitM @ ( bit0 @ N ) )
      = ( bit1 @ ( bitM @ N ) ) ) ).

% semiring_norm(27)
thf(fact_191_semiring__normalization__rules_I19_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ Lx @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Rx @ ( times_times @ A @ Lx @ Ry ) ) ) ) ).

% semiring_normalization_rules(19)
thf(fact_192_semiring__normalization__rules_I18_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ Lx @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ Ry ) ) ) ).

% semiring_normalization_rules(18)
thf(fact_193_semiring__normalization__rules_I17_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Rx )
          = ( times_times @ A @ Lx @ ( times_times @ A @ Ly @ Rx ) ) ) ) ).

% semiring_normalization_rules(17)
thf(fact_194_semiring__normalization__rules_I16_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Rx )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ Ly ) ) ) ).

% semiring_normalization_rules(16)
thf(fact_195_semiring__normalization__rules_I15_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Rx @ ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Ry ) ) ) ) ).

% semiring_normalization_rules(15)
thf(fact_196_semiring__normalization__rules_I14_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Lx @ ( times_times @ A @ Ly @ ( times_times @ A @ Rx @ Ry ) ) ) ) ) ).

% semiring_normalization_rules(14)
thf(fact_197_semiring__normalization__rules_I13_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ ( times_times @ A @ Ly @ Ry ) ) ) ) ).

% semiring_normalization_rules(13)
thf(fact_198_semiring__normalization__rules_I7_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ( ( times_times @ A )
        = ( ^ [A4: A,B4: A] : ( times_times @ A @ B4 @ A4 ) ) ) ) ).

% semiring_normalization_rules(7)
thf(fact_199_semiring__normalization__rules_I11_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( one_one @ A ) @ A2 )
          = A2 ) ) ).

% semiring_normalization_rules(11)
thf(fact_200_hamming_H_Osimps,axiom,
    ( hammin1630468845amming
    = ( ^ [Uu: product_unit] : ( coinductive_LCons @ nat @ ( one_one @ nat ) @ ( hammin1138290136lmerge @ nat @ ( coinductive_lmap @ nat @ nat @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit0 @ one2 ) ) ) @ ( hammin1630468845amming @ product_Unity ) ) @ ( hammin1138290136lmerge @ nat @ ( coinductive_lmap @ nat @ nat @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit1 @ one2 ) ) ) @ ( hammin1630468845amming @ product_Unity ) ) @ ( coinductive_lmap @ nat @ nat @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit1 @ ( bit0 @ one2 ) ) ) ) @ ( hammin1630468845amming @ product_Unity ) ) ) ) ) ) ) ).

% hamming'.simps
thf(fact_201_sub__num__simps_I2_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [L: num] :
          ( ( neg_numeral_sub @ A @ one2 @ ( bit0 @ L ) )
          = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( bitM @ L ) ) ) ) ) ).

% sub_num_simps(2)
thf(fact_202_dbl__dec__simps_I4_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_dbl_dec @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) )
        = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( bit1 @ one2 ) ) ) ) ) ).

% dbl_dec_simps(4)
thf(fact_203_compl__eq__compl__iff,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ( uminus_uminus @ A @ X )
            = ( uminus_uminus @ A @ Y ) )
          = ( X = Y ) ) ) ).

% compl_eq_compl_iff
thf(fact_204_double__compl,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( uminus_uminus @ A @ ( uminus_uminus @ A @ X ) )
          = X ) ) ).

% double_compl
thf(fact_205_uminus__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( uminus @ B @ ( type2 @ B ) )
     => ( ( uminus_uminus @ ( A > B ) )
        = ( ^ [A5: A > B,X4: A] : ( uminus_uminus @ B @ ( A5 @ X4 ) ) ) ) ) ).

% uminus_apply
thf(fact_206_neg__equal__iff__equal,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ( uminus_uminus @ A @ A2 )
            = ( uminus_uminus @ A @ B2 ) )
          = ( A2 = B2 ) ) ) ).

% neg_equal_iff_equal
thf(fact_207_add_Oinverse__inverse,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( uminus_uminus @ A @ ( uminus_uminus @ A @ A2 ) )
          = A2 ) ) ).

% add.inverse_inverse
thf(fact_208_compl__le__compl__iff,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ ( uminus_uminus @ A @ X ) @ ( uminus_uminus @ A @ Y ) )
          = ( ord_less_eq @ A @ Y @ X ) ) ) ).

% compl_le_compl_iff
thf(fact_209_neg__le__iff__le,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A] :
          ( ( ord_less_eq @ A @ ( uminus_uminus @ A @ B2 ) @ ( uminus_uminus @ A @ A2 ) )
          = ( ord_less_eq @ A @ A2 @ B2 ) ) ) ).

% neg_le_iff_le
thf(fact_210_neg__numeral__eq__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) )
            = ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) )
          = ( M = N ) ) ) ).

% neg_numeral_eq_iff
thf(fact_211_mult__minus1__right,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A @ ( type2 @ A ) )
     => ! [Z: A] :
          ( ( times_times @ A @ Z @ ( uminus_uminus @ A @ ( one_one @ A ) ) )
          = ( uminus_uminus @ A @ Z ) ) ) ).

% mult_minus1_right
thf(fact_212_mult__minus1,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A @ ( type2 @ A ) )
     => ! [Z: A] :
          ( ( times_times @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) @ Z )
          = ( uminus_uminus @ A @ Z ) ) ) ).

% mult_minus1
thf(fact_213_dbl__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K3: num] :
          ( ( neg_numeral_dbl @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ K3 ) ) )
          = ( uminus_uminus @ A @ ( neg_numeral_dbl @ A @ ( numeral_numeral @ A @ K3 ) ) ) ) ) ).

% dbl_simps(1)
thf(fact_214_dbl__inc__simps_I4_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_dbl_inc @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) )
        = ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ).

% dbl_inc_simps(4)
thf(fact_215_neg__one__eq__numeral__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( ( uminus_uminus @ A @ ( one_one @ A ) )
            = ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) )
          = ( N = one2 ) ) ) ).

% neg_one_eq_numeral_iff
thf(fact_216_numeral__eq__neg__one__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) )
            = ( uminus_uminus @ A @ ( one_one @ A ) ) )
          = ( N = one2 ) ) ) ).

% numeral_eq_neg_one_iff
thf(fact_217_mult__neg__numeral__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( times_times @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) )
          = ( numeral_numeral @ A @ ( times_times @ num @ M @ N ) ) ) ) ).

% mult_neg_numeral_simps(1)
thf(fact_218_mult__neg__numeral__simps_I2_J,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( times_times @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) ) @ ( numeral_numeral @ A @ N ) )
          = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( times_times @ num @ M @ N ) ) ) ) ) ).

% mult_neg_numeral_simps(2)
thf(fact_219_mult__neg__numeral__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ M ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) )
          = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( times_times @ num @ M @ N ) ) ) ) ) ).

% mult_neg_numeral_simps(3)
thf(fact_220_semiring__norm_I170_J,axiom,
    ! [B: $tType] :
      ( ( ring_1 @ B @ ( type2 @ B ) )
     => ! [V: num,W: num,Y: B] :
          ( ( times_times @ B @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ V ) ) @ ( times_times @ B @ ( numeral_numeral @ B @ W ) @ Y ) )
          = ( times_times @ B @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ ( times_times @ num @ V @ W ) ) ) @ Y ) ) ) ).

% semiring_norm(170)
thf(fact_221_semiring__norm_I171_J,axiom,
    ! [B: $tType] :
      ( ( ring_1 @ B @ ( type2 @ B ) )
     => ! [V: num,W: num,Y: B] :
          ( ( times_times @ B @ ( numeral_numeral @ B @ V ) @ ( times_times @ B @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ W ) ) @ Y ) )
          = ( times_times @ B @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ ( times_times @ num @ V @ W ) ) ) @ Y ) ) ) ).

% semiring_norm(171)
thf(fact_222_semiring__norm_I172_J,axiom,
    ! [B: $tType] :
      ( ( ring_1 @ B @ ( type2 @ B ) )
     => ! [V: num,W: num,Y: B] :
          ( ( times_times @ B @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ V ) ) @ ( times_times @ B @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ W ) ) @ Y ) )
          = ( times_times @ B @ ( numeral_numeral @ B @ ( times_times @ num @ V @ W ) ) @ Y ) ) ) ).

% semiring_norm(172)
thf(fact_223_neg__numeral__le__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( ord_less_eq @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) )
          = ( ord_less_eq @ num @ N @ M ) ) ) ).

% neg_numeral_le_iff
thf(fact_224_not__neg__one__le__neg__numeral__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A @ ( type2 @ A ) )
     => ! [M: num] :
          ( ( ~ ( ord_less_eq @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) ) ) )
          = ( M != one2 ) ) ) ).

% not_neg_one_le_neg_numeral_iff
thf(fact_225_dbl__dec__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K3: num] :
          ( ( neg_numeral_dbl_dec @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ K3 ) ) )
          = ( uminus_uminus @ A @ ( neg_numeral_dbl_inc @ A @ ( numeral_numeral @ A @ K3 ) ) ) ) ) ).

% dbl_dec_simps(1)
thf(fact_226_dbl__inc__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [K3: num] :
          ( ( neg_numeral_dbl_inc @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ K3 ) ) )
          = ( uminus_uminus @ A @ ( neg_numeral_dbl_dec @ A @ ( numeral_numeral @ A @ K3 ) ) ) ) ) ).

% dbl_inc_simps(1)
thf(fact_227_sub__num__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [L: num] :
          ( ( neg_numeral_sub @ A @ one2 @ ( bit1 @ L ) )
          = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( bit0 @ L ) ) ) ) ) ).

% sub_num_simps(3)
thf(fact_228_dbl__simps_I4_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ( ( neg_numeral_dbl @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) )
        = ( uminus_uminus @ A @ ( numeral_numeral @ A @ ( bit0 @ one2 ) ) ) ) ) ).

% dbl_simps(4)
thf(fact_229_ring__normalization__rules_I1_J,axiom,
    ! [A: $tType] :
      ( ( comm_ring_1 @ A @ ( type2 @ A ) )
     => ( ( uminus_uminus @ A )
        = ( times_times @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ) ).

% ring_normalization_rules(1)
thf(fact_230_numeral__times__minus__swap,axiom,
    ! [A: $tType] :
      ( ( comm_ring_1 @ A @ ( type2 @ A ) )
     => ! [W: num,X: A] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ W ) @ ( uminus_uminus @ A @ X ) )
          = ( times_times @ A @ X @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ W ) ) ) ) ) ).

% numeral_times_minus_swap
thf(fact_231_numeral__neq__neg__one,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( numeral_numeral @ A @ N )
         != ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ).

% numeral_neq_neg_one
thf(fact_232_one__neq__neg__numeral,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [N: num] :
          ( ( one_one @ A )
         != ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) ) ) ).

% one_neq_neg_numeral
thf(fact_233_hamming__def,axiom,
    ( hammin2015774020amming
    = ( hammin1630468845amming @ product_Unity ) ) ).

% hamming_def
thf(fact_234_neg__numeral__neq__numeral,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) )
         != ( numeral_numeral @ A @ N ) ) ) ).

% neg_numeral_neq_numeral
thf(fact_235_numeral__neq__neg__numeral,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ( ( numeral_numeral @ A @ M )
         != ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) ) ) ).

% numeral_neq_neg_numeral
thf(fact_236_fun__Compl__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( uminus @ B @ ( type2 @ B ) )
     => ( ( uminus_uminus @ ( A > B ) )
        = ( ^ [A5: A > B,X4: A] : ( uminus_uminus @ B @ ( A5 @ X4 ) ) ) ) ) ).

% fun_Compl_def
thf(fact_237_compl__le__swap2,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ( ord_less_eq @ A @ ( uminus_uminus @ A @ Y ) @ X )
         => ( ord_less_eq @ A @ ( uminus_uminus @ A @ X ) @ Y ) ) ) ).

% compl_le_swap2
thf(fact_238_compl__le__swap1,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ( ord_less_eq @ A @ Y @ ( uminus_uminus @ A @ X ) )
         => ( ord_less_eq @ A @ X @ ( uminus_uminus @ A @ Y ) ) ) ) ).

% compl_le_swap1
thf(fact_239_compl__mono,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ord_less_eq @ A @ ( uminus_uminus @ A @ Y ) @ ( uminus_uminus @ A @ X ) ) ) ) ).

% compl_mono
thf(fact_240_le__minus__one__simps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A @ ( type2 @ A ) )
     => ( ord_less_eq @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) @ ( one_one @ A ) ) ) ).

% le_minus_one_simps(2)
thf(fact_241_le__minus__one__simps_I4_J,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A @ ( type2 @ A ) )
     => ~ ( ord_less_eq @ A @ ( one_one @ A ) @ ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ).

% le_minus_one_simps(4)
thf(fact_242_neg__numeral__le__numeral,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] : ( ord_less_eq @ A @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ M ) ) @ ( numeral_numeral @ A @ N ) ) ) ).

% neg_numeral_le_numeral
thf(fact_243_not__numeral__le__neg__numeral,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A @ ( type2 @ A ) )
     => ! [M: num,N: num] :
          ~ ( ord_less_eq @ A @ ( numeral_numeral @ A @ M ) @ ( uminus_uminus @ A @ ( numeral_numeral @ A @ N ) ) ) ) ).

% not_numeral_le_neg_numeral
thf(fact_244_le__minus__iff,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ ( uminus_uminus @ A @ B2 ) )
          = ( ord_less_eq @ A @ B2 @ ( uminus_uminus @ A @ A2 ) ) ) ) ).

% le_minus_iff
thf(fact_245_minus__le__iff,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ ( uminus_uminus @ A @ A2 ) @ B2 )
          = ( ord_less_eq @ A @ ( uminus_uminus @ A @ B2 ) @ A2 ) ) ) ).

% minus_le_iff
thf(fact_246_le__imp__neg__le,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ord_less_eq @ A @ ( uminus_uminus @ A @ B2 ) @ ( uminus_uminus @ A @ A2 ) ) ) ) ).

% le_imp_neg_le
thf(fact_247_minus__equation__iff,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ( uminus_uminus @ A @ A2 )
            = B2 )
          = ( ( uminus_uminus @ A @ B2 )
            = A2 ) ) ) ).

% minus_equation_iff
thf(fact_248_equation__minus__iff,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( A2
            = ( uminus_uminus @ A @ B2 ) )
          = ( B2
            = ( uminus_uminus @ A @ A2 ) ) ) ) ).

% equation_minus_iff
thf(fact_249_one__neq__neg__one,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A @ ( type2 @ A ) )
     => ( ( one_one @ A )
       != ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ).

% one_neq_neg_one
thf(fact_250_mult__1s_I3_J,axiom,
    ! [B: $tType] :
      ( ( ring_1 @ B @ ( type2 @ B ) )
     => ! [B2: B] :
          ( ( times_times @ B @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ one2 ) ) @ B2 )
          = ( uminus_uminus @ B @ B2 ) ) ) ).

% mult_1s(3)
thf(fact_251_mult__1s_I4_J,axiom,
    ! [B: $tType] :
      ( ( ring_1 @ B @ ( type2 @ B ) )
     => ! [B2: B] :
          ( ( times_times @ B @ B2 @ ( uminus_uminus @ B @ ( numeral_numeral @ B @ one2 ) ) )
          = ( uminus_uminus @ B @ B2 ) ) ) ).

% mult_1s(4)

%----Type constructors (50)
thf(tcon_fun___Lattices_Osemilattice__inf,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( semilattice_inf @ A7 @ ( type2 @ A7 ) )
     => ( semilattice_inf @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Lattices_Oboolean__algebra,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( boolean_algebra @ A7 @ ( type2 @ A7 ) )
     => ( boolean_algebra @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( preorder @ A7 @ ( type2 @ A7 ) )
     => ( preorder @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Lattices_Olattice,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( lattice @ A7 @ ( type2 @ A7 ) )
     => ( lattice @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( order @ A7 @ ( type2 @ A7 ) )
     => ( order @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( ord @ A7 @ ( type2 @ A7 ) )
     => ( ord @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Groups_Ouminus,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( uminus @ A7 @ ( type2 @ A7 ) )
     => ( uminus @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Lattices_Osemilattice__inf_1,axiom,
    semilattice_inf @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1 @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Osemigroup__mult,axiom,
    semigroup_mult @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Num_Osemiring__numeral,axiom,
    semiring_numeral @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0 @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Opreorder_2,axiom,
    preorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Olinorder,axiom,
    linorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Lattices_Olattice_3,axiom,
    lattice @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oorder_4,axiom,
    order @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oord_5,axiom,
    ord @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Num_Onumeral,axiom,
    numeral @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oone,axiom,
    one @ nat @ ( type2 @ nat ) ).

thf(tcon_Num_Onum___Orderings_Opreorder_6,axiom,
    preorder @ num @ ( type2 @ num ) ).

thf(tcon_Num_Onum___Orderings_Olinorder_7,axiom,
    linorder @ num @ ( type2 @ num ) ).

thf(tcon_Num_Onum___Orderings_Oorder_8,axiom,
    order @ num @ ( type2 @ num ) ).

thf(tcon_Num_Onum___Orderings_Oord_9,axiom,
    ord @ num @ ( type2 @ num ) ).

thf(tcon_HOL_Obool___Lattices_Osemilattice__inf_10,axiom,
    semilattice_inf @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Oboolean__algebra_11,axiom,
    boolean_algebra @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_12,axiom,
    preorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder_13,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Olattice_14,axiom,
    lattice @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder_15,axiom,
    order @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oord_16,axiom,
    ord @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Groups_Ouminus_17,axiom,
    uminus @ $o @ ( type2 @ $o ) ).

thf(tcon_Extended__Nat_Oenat___Lattices_Osemilattice__inf_18,axiom,
    semilattice_inf @ extended_enat @ ( type2 @ extended_enat ) ).

thf(tcon_Extended__Nat_Oenat___Groups_Oab__semigroup__mult_19,axiom,
    ab_semigroup_mult @ extended_enat @ ( type2 @ extended_enat ) ).

thf(tcon_Extended__Nat_Oenat___Groups_Ocomm__monoid__mult_20,axiom,
    comm_monoid_mult @ extended_enat @ ( type2 @ extended_enat ) ).

thf(tcon_Extended__Nat_Oenat___Rings_Ocomm__semiring__1_21,axiom,
    comm_semiring_1 @ extended_enat @ ( type2 @ extended_enat ) ).

thf(tcon_Extended__Nat_Oenat___Groups_Osemigroup__mult_22,axiom,
    semigroup_mult @ extended_enat @ ( type2 @ extended_enat ) ).

thf(tcon_Extended__Nat_Oenat___Num_Osemiring__numeral_23,axiom,
    semiring_numeral @ extended_enat @ ( type2 @ extended_enat ) ).

thf(tcon_Extended__Nat_Oenat___Nat_Osemiring__char__0_24,axiom,
    semiring_char_0 @ extended_enat @ ( type2 @ extended_enat ) ).

thf(tcon_Extended__Nat_Oenat___Orderings_Opreorder_25,axiom,
    preorder @ extended_enat @ ( type2 @ extended_enat ) ).

thf(tcon_Extended__Nat_Oenat___Orderings_Olinorder_26,axiom,
    linorder @ extended_enat @ ( type2 @ extended_enat ) ).

thf(tcon_Extended__Nat_Oenat___Groups_Omonoid__mult_27,axiom,
    monoid_mult @ extended_enat @ ( type2 @ extended_enat ) ).

thf(tcon_Extended__Nat_Oenat___Lattices_Olattice_28,axiom,
    lattice @ extended_enat @ ( type2 @ extended_enat ) ).

thf(tcon_Extended__Nat_Oenat___Orderings_Oorder_29,axiom,
    order @ extended_enat @ ( type2 @ extended_enat ) ).

thf(tcon_Extended__Nat_Oenat___Orderings_Oord_30,axiom,
    ord @ extended_enat @ ( type2 @ extended_enat ) ).

thf(tcon_Extended__Nat_Oenat___Num_Onumeral_31,axiom,
    numeral @ extended_enat @ ( type2 @ extended_enat ) ).

thf(tcon_Extended__Nat_Oenat___Groups_Oone_32,axiom,
    one @ extended_enat @ ( type2 @ extended_enat ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ord_less_eq @ extended_enat @ ( inf_inf @ extended_enat @ ( coinductive_llength @ nat @ ( coinductive_lmap @ nat @ nat @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit1 @ one2 ) ) ) @ hammin2015774020amming ) ) @ ( coinductive_llength @ nat @ ( coinductive_lmap @ nat @ nat @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit1 @ ( bit0 @ one2 ) ) ) ) @ hammin2015774020amming ) ) ) @ ( coinductive_llength @ nat @ ( hammin1138290136lmerge @ nat @ ( coinductive_lmap @ nat @ nat @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit1 @ one2 ) ) ) @ hammin2015774020amming ) @ ( coinductive_lmap @ nat @ nat @ ( times_times @ nat @ ( numeral_numeral @ nat @ ( bit1 @ ( bit0 @ one2 ) ) ) ) @ hammin2015774020amming ) ) ) ).

%------------------------------------------------------------------------------
